---
title: "preparation PPMI dataset"
author: "AHMED hEMEDAN"
date: "03/01/2021"
---
library(readxl)
library(tidyverse)
metadata<- read_excel("Full sample and patient annotations for the PPMI cohort.xlsx")
mirna<- read_excel("std_quantification_rpm_norm_mirna.final_ids.xlsx")
swedd <-read_excel("swedd1.xlsx")
swedd %>% remove_rownames %>% column_to_rownames(var="Sequencing sample ID")
swedd_mirna <-intersect( colnames(swedd),  colnames(mirna))
write.csv(swedd_mirna,"intrsct_sweddmirna.csv")
sedd<- mirna %>% select("miRNA","PPMI-IR1.3915.V06.328414.5628-SL-4517")
sweddmirna<-read_excel("sweddmirna1.xlsx")
swedd_rowMirna <- sweddmirna%>% remove_rownames %>% column_to_rownames(var="miRNA")
write.table(swedd_rowMirna,"swedd_rowMirna.xlsx")


## Intersect with databases for potential miRNA
data("mirna", package = "anamiR", envir = environment())
data("pheno.mirna", package = "anamiR", envir = environment())
data("mrna", package = "anamiR", envir = environment())
data("pheno.mrna", package = "anamiR", envir = environment())

## SummarizedExperiment class
require(SummarizedExperiment)
mirna_se <- SummarizedExperiment(
  assays = SimpleList(counts=mirna),
  colData = pheno.mirna)

## SummarizedExperiment class
require(SummarizedExperiment)
mrna_se <- SummarizedExperiment(
  assays = SimpleList(counts=mrna),
  colData = pheno.mrna)

## Finding differential miRNA from miRNA expression data with t.test
mirna_d <- differExp_discrete(
  se = mirna_se,
  class = "ER",
  method = "t.test"
)

## Finding differential mRNA from mRNA expression data with t.test
mrna_d <- differExp_discrete(
  se = mrna_se,
  class = "ER",
  method = "t.test"
)

## Convert annotation to miRBse 21
mirna_21 <- miR_converter(data = mirna_d, original_version = 17)

## Correlation
cor <- negative_cor(mrna_data = mrna_d, mirna_data = mirna_21)
